
import SwiftUI

actor ItemData {
   var counter: Int = 0

   func incrementCount() -> String {
      counter += 1
      return "Value: \(counter)"
   }
}
struct ContentView: View {
   var item: ItemData = ItemData()

   var body: some View {
      Button("Run Task") {
         Task {
            await loadImage(name: "My Image")
         }
      }
   }
   @concurrent
   func loadImage(name: String) async {
      sleep(5)
      let total = await item.incrementCount()
      print("Total: \(total)")
   }
}

#Preview {
    ContentView()
}
